package poly.test;
import poly.*;
import poly.op.*;
import poly.factory.*;

import junit.framework.TestCase;

public class Test_Div extends TestCase {
  
  
  public void test_Div() {
    IPolyFact fac = CompPolyFact.Singleton;
    IPolyOp algo = new Div(fac);
    
    IPoly pLeft = fac.makeConstPoly(5.0);
    IPoly pRight = fac.makeConstPoly(2.0);
    
    assertEquals("5.0 / 2.0", "2.5", pLeft.execute(algo,pRight).toString());
    
    pRight = fac.makeNCPoly(3.0, 1, pRight);
    
    assertEquals("5.0 / (3.0x + 2.0)", "0.0", pLeft.execute(algo,pRight).toString());

    pLeft = fac.makeNCPoly(10.5, 1, pLeft);
    
    assertEquals("(10.5x + 5.0) / (3.0x + 2.0)", "3.5", pLeft.execute(algo,pRight).toString());
    
    pLeft = fac.makeNCPoly(12.0, 2, pLeft);

    assertEquals(pLeft.toString()+" / "+ pRight.toString(), "4.0x^1 + 0.8333333333333334", pLeft.execute(algo,pRight).toString());
    
    pLeft = fac.makeNCPoly(16.5, 4, pLeft);

    assertEquals(pLeft.toString()+" / "+ pRight.toString(), 
                 "5.5x^3 + -3.6666666666666665x^2 + 6.444444444444444x^1 + -0.7962962962962958", 
                 pLeft.execute(algo,pRight).toString());
    
    pRight = fac.makeConstPoly(5.0);

    assertEquals(pLeft.toString()+" / "+ pRight.toString(), 
                 "3.3x^4 + 2.4x^2 + 2.1x^1 + 1.0", 
                 pLeft.execute(algo,pRight).toString());
  }
 
}
